﻿//////////////////////////////////////////////
// ShaderInstanceMemorySlot.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class ShaderInstanceCustomSlot ;
	class System ;
}

/// Includes ---------------------------------
	
// nkGraphics
#include "ShaderMemorySlot.h"

#include "../../Dll/DllDefines.h"

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ShaderInstanceMemorySlot : public ShaderMemorySlot
	{
		public :

			enum class DATA_TYPE
			{
				UNKNOWN = 0,
				// Transformations
				WORLD_MATRIX,
				WORLD_MATRIX_INV_TRANSPOSE,
				// Custom
				CUSTOM
			} ;
		
		public :
		
			// Constructor, destructor
			ShaderInstanceMemorySlot (System* system) noexcept ;
			virtual ~ShaderInstanceMemorySlot () ;

			// Getters
			DATA_TYPE getType () const ;
			nkMemory::StringView getSemanticName () const ;
			virtual unsigned int getDataSize () const ;
			virtual nkMemory::StringView getDataTypeAsString () const override ;

			// Setters
			void setAsWorldMatrix () ;
			void setAsWorldMatrixInvTranspose () ;
			void setAsCustom (ShaderInstanceCustomSlot* slot) ;

			// Import / export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Functions
			// Data erasure
			void _deleteData () ;

		protected :
		
			// Attributes
			// Parent system
			System* _system ;
			// Data if required
			void* _data ;
			// Size of them in bytes
			unsigned int _dataSize ;

			// Active data type
			DATA_TYPE _type ;
	} ;
}